/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import info.msxlaunchers.openmsx.common.ActionDecider;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.builder.GameBuilder;
import info.msxlaunchers.openmsx.launcher.data.backup.DatabaseBackup;
import info.msxlaunchers.openmsx.launcher.data.extra.ExtraData;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.RelatedGame;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.BackupDatabaseAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.CreateDatabaseAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.DeleteDatabaseAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.DeleteDatabaseBackupAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.DeleteGamesAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersister;
import info.msxlaunchers.openmsx.launcher.persistence.game.GetDatabaseBackupsAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.GetDatabasesAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.GetGamesAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.GetRelatedGamesWithLauncherLinksAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.MoveGamesAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.RenameDatabaseAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.RestoreDatabaseBackupAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.SaveGamesAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.UpdateGameAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.UpdateGameExtraDataAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.UpdateMachineAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Singleton
final class EmbeddedDatabaseGamePersister
implements GamePersister {
    private final GameBuilder gameBuilder;
    private final String databaseFullPath;

    @Inject
    EmbeddedDatabaseGamePersister(@Named(value="EmbeddedDatabaseFullPath") String databaseFullPath, GameBuilder gameBuilder) {
        this.databaseFullPath = databaseFullPath;
        this.gameBuilder = gameBuilder;
    }

    @Override
    public void createDatabase(String database) throws GamePersistenceException {
        if (Utils.isEmpty(database)) {
            throw new GamePersistenceException(GamePersistenceExceptionIssue.DATABASE_NULL_NAME);
        }
        try {
            new CreateDatabaseAction(database).execute(this.databaseFullPath);
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public void deleteDatabase(String database) throws GamePersistenceException {
        Objects.requireNonNull(database);
        try {
            new DeleteDatabaseAction(database).execute(this.databaseFullPath);
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public void renameDatabase(String oldDatabase, String newDatabase) throws GamePersistenceException {
        Objects.requireNonNull(newDatabase);
        Objects.requireNonNull(oldDatabase);
        try {
            new RenameDatabaseAction(oldDatabase, newDatabase).execute(this.databaseFullPath);
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public DatabaseBackup backupDatabase(String database) throws GamePersistenceException {
        Objects.requireNonNull(database);
        try {
            return (DatabaseBackup)new BackupDatabaseAction(database).execute(this.databaseFullPath).getResult();
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public void restoreBackup(DatabaseBackup backup) throws GamePersistenceException {
        Objects.requireNonNull(backup);
        try {
            new RestoreDatabaseBackupAction(backup).execute(this.databaseFullPath);
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public void deleteBackup(DatabaseBackup backup) throws GamePersistenceException {
        Objects.requireNonNull(backup);
        try {
            new DeleteDatabaseBackupAction(backup).execute(this.databaseFullPath);
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public void recreateDatabase(String database) throws GamePersistenceException {
        Objects.requireNonNull(database);
        Set<Game> games = this.getGames(database);
        this.deleteGames(games, database);
    }

    @Override
    public Set<String> getDatabases() {
        Set<String> databases;
        try {
            databases = (Set)new GetDatabasesAction().execute(this.databaseFullPath).getResult();
        }
        catch (LauncherPersistenceException gpe) {
            databases = new HashSet<String>();
        }
        return databases;
    }

    @Override
    public Set<DatabaseBackup> getBackups(String database) {
        Set backups;
        try {
            backups = (Set)new GetDatabaseBackupsAction(database).execute(this.databaseFullPath).getResult();
        }
        catch (LauncherPersistenceException gpe) {
            backups = new HashSet();
        }
        return Collections.unmodifiableSet(backups);
    }

    @Override
    public int updateGameExtraDataInDatabases(Map<String, ExtraData> extraDataMap) throws GamePersistenceException {
        Objects.requireNonNull(extraDataMap);
        try {
            return (Integer)new UpdateGameExtraDataAction(this.gameBuilder, extraDataMap).execute(this.databaseFullPath).getResult();
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public Set<Game> getGames(String database) throws GamePersistenceException {
        try {
            return (Set)new GetGamesAction(database).execute(this.databaseFullPath).getResult();
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public void saveGame(Game game, String database) throws GamePersistenceException {
        Objects.requireNonNull(database);
        Objects.requireNonNull(game);
        this.saveGames(Collections.singleton(game), database);
    }

    @Override
    public void saveGames(Set<Game> games, String database) throws GamePersistenceException {
        Objects.requireNonNull(games);
        Objects.requireNonNull(database);
        try {
            new SaveGamesAction(games, database).execute(this.databaseFullPath);
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public void updateGame(Game oldGame, Game newGame, String database) throws GamePersistenceException {
        Objects.requireNonNull(oldGame);
        Objects.requireNonNull(newGame);
        Objects.requireNonNull(database);
        try {
            new UpdateGameAction(oldGame, newGame, database).execute(this.databaseFullPath);
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public void deleteGame(Game game, String database) throws GamePersistenceException {
        Objects.requireNonNull(game);
        this.deleteGames(Collections.singleton(game), database);
    }

    @Override
    public void deleteGames(Set<Game> games, String database) throws GamePersistenceException {
        Objects.requireNonNull(games);
        Objects.requireNonNull(database);
        try {
            new DeleteGamesAction(games, database).execute(this.databaseFullPath);
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public Set<Game> moveGames(Set<Game> games, String oldDatabase, String newDatabase, ActionDecider actionDecider) throws GamePersistenceException {
        Objects.requireNonNull(games);
        Objects.requireNonNull(oldDatabase);
        Objects.requireNonNull(newDatabase);
        Objects.requireNonNull(actionDecider);
        try {
            return (Set)new MoveGamesAction(games, oldDatabase, newDatabase, actionDecider).execute(this.databaseFullPath).getResult();
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public int updateMachine(String to, String from, String database, boolean backupDatabases) throws GamePersistenceException {
        Objects.requireNonNull(to);
        try {
            return (Integer)new UpdateMachineAction(to, from, database, backupDatabases).execute(this.databaseFullPath).getResult();
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }

    @Override
    public List<RelatedGame> getRelatedGamesWithLauncherLinks(List<RelatedGame> relatedGames) throws GamePersistenceException {
        Objects.requireNonNull(relatedGames);
        try {
            return (List)new GetRelatedGamesWithLauncherLinksAction(relatedGames).execute(this.databaseFullPath).getResult();
        }
        catch (LauncherPersistenceException lpe) {
            throw (GamePersistenceException)lpe.getException();
        }
    }
}

